const mix = require("laravel-mix");
const webpack = require("webpack");
/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent Api for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */

if (!mix.inProduction()) {
    require("laravel-mix-bundle-analyzer");
    mix.bundleAnalyzer();
}

const path = require("path");
mix.webpackConfig({
    module: {
        noParse: [
            /[\/\\]node_modules[\/\\]\jquery[\/\\]\jquery\.js$/
        ]
    },
    externals: {
        jquery: 'jQuery'
    },
    resolve: {
        alias: {
            "@": path.resolve(__dirname, "resources/js/")
        }
    },
    output: {
        filename: "js/vue/[name].js",
        chunkFilename: "js/vue/[name].js",
       // chunkFilename: "js/vue/[name].[chunkhash].js",
        // chunkFilename: mix.inProduction() ? "js/front/chunks/[name].[chunkhash].js" : "js/front/chunks/[name].js",
        //filename: '[name].[chunkhash].js',
        // path: path.resolve(__dirname, 'dist'),
    },
    optimization: {
        moduleIds: 'hashed',
        /*  runtimeChunk: 'single',
         splitChunks: {
         minSize: 10000,
         maxSize: 250000,
         cacheGroups: {
         vendor: {
         test: /[\\/]node_modules[\\/]/,
         name(module) {
         // get the name. E.g. node_modules/packageName/not/this/part.js
         // or node_modules/packageName
         const packageName = module.context.match(/[\\/]node_modules[\\/](.*?)([\\/]|$)/)[1];

         // npm package names are URL-safe, but some servers don't like @ symbols
         // return `npm.${packageName.replace('@', '')}`;
         },
         },
         },
         }, */
    },
    plugins: [
        new webpack.ContextReplacementPlugin(/moment[\/\\]locale$/, /bn|en-gb/),
        new webpack.HashedModuleIdsPlugin(),
    ]
})
    .js("resources/js/edu.js", "")
    .sass("resources/sass/app.scss", "public/css")
    .extract();

    if(mix.inProduction){
        mix.version()
        .then((stats) => {

            // We're appending random int to the versioned files to guarantee
            // that all assets are fully re-cached on every new version (md5 sucks at this)

            let file = File.find(stats.compilation.options.output.path + '/mix-manifest.json');
            let assets = JSON.parse(file.read());

            let new_assets = {};
            Object.keys(assets).forEach(function (item) {
                let addedTimestamp = '-' + Date.now();
                new_assets[item] = assets[item] + addedTimestamp;
            });

            file.write(JSON.stringify(new_assets, null, 2));
            })
    }
