<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 12/10/15
 * Time: 3:56 PM
 */

use App\Models\Company\GlobalCompany;
use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Package\EduPackageModule;
use App\Models\Permission\UserExtraPermission;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use Illuminate\Support\Carbon;


/**
 * @return string
 */

function advAttOptions()
{

    $theOption = (new \App\Models\Setting\Setting())->whereSettingName('Attendance')->first();
    $advanced = $theOption->setting_value;

    if ($advanced == '1') {
        return true;
    }

    return false;
}

if (!defined('SITE_ID')) {

    define('SITE_ID', 'xxsiteId');
}

function startlegend()
{
    $formField = '';

    return $formField .= '<div class="row">';

}

function endlegend()
{
    $formField = '';

    return $formField .= '<div class="row">';

}

function inputLangControl()
{


    $languages = config('app.locales');
    $lang_def = 'en';
    $formField = '';
    $formField .= '<select class="control_lang">';
    foreach ($languages as $key => $value) {
        $formField .= '<option value="' . $key . '">' . $value . '</option>';
    }
    $formField .= '</select>';

    return $formField;
}


/**
 * @param array $field
 * @return string
 */

function inputField($field = [])
{

    $languages = config('app.locales');
    $lang_def = 'en';
    $formField = '';


    switch (isset($field['type']) ? $field['type'] : 'invalid') {

        case 'startlegend':
            $formField .= function_exists('startlegend') ? startlegend($field) : null;
            break;
        case 'endlegend':
            $formField .= function_exists('endlegend') ? endlegend($field) : null;
            break;
        case 'label':
            $formField .= function_exists('fieldLabel') ? fieldLabel($field) : null;
            break;
        case 'text':
            $formField .= function_exists('fieldText') ? fieldText($field, $languages) : null;
            break;
        case 'textarea':
            $formField .= function_exists('fieldTextArea') ? fieldTextArea($field, $languages) : null;
            break;
        case 'select':
            $formField .= function_exists('fieldSelect') ? fieldSelect($field, $languages) : null;
            break;
        case 'checkbox':
            $formField .= function_exists('fieldCheckBox') ? fieldCheckBox($field) : null;
            break;
        case 'checkboxsalary':
            $formField .= function_exists('fieldCheckBoxForSalary') ? fieldCheckBoxForSalary($field) : null;
            break;
        case 'radio':
            $formField .= function_exists('fieldRadio') ? fieldRadio($field) : null;
            break;
        case 'email':
            $formField .= function_exists('fieldEmail') ? fieldEmail($field) : null;
            break;
        case 'file':
            $formField .= function_exists('fieldFile') ? fieldFile($field) : null;
            break;
        case 'password':
            $formField .= function_exists('fieldPassword') ? fieldPassword($field) : null;
            break;
        case 'number':
            $formField .= function_exists('fieldNumber') ? fieldNumber($field) : null;
            break;
        case 'date':
            $formField .= function_exists('fieldDate') ? fieldDate($field) : null;
            break;
        case 'hidden':
            $formField .= function_exists('fieldHidden') ? fieldHidden($field) : null;
            break;
        case 'submit':
            $formField .= function_exists('formSubmit') ? formSubmit($field) : null;
            break;
        case 'startrow':
            $formField .= function_exists('startRow') ? startRow() : null;
            break;
        case 'endrow':
            $formField .= function_exists('endRow') ? endRow() : null;
            break;
        case 'salaryfield':
            $formField .= function_exists('salaryField') ? salaryField($field, $languages) : null;
            break;
        case 'marksType':
            $formField .= function_exists('marksTypeField') ? marksTypeField($field, $languages) : null;
            break;
        case 'marksTypeTable':
            $formField .= function_exists('marksTypeTable') ? marksTypeTable($field) : null;
            break;

        case 'subjectTable':
            $formField .= function_exists('subjectTable') ? subjectTable($field) : null;
            break;
        case 'img':
            $formField .= function_exists('imageField') ? imageField($field) : null;
            break;
        case 'grimg':
            $formField .= function_exists('grImage') ? grImage($field) : null;
            break;

        default:
            return null;
    }

    return $formField;
}

if (!function_exists('subjectTable')) {
    function subjectTable($field)
    {
        $Sl = 1;
        $formField = '';
        $formField .= '<div id="" class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
        $formField .= Form::label(
            isset($field['name']) ? $field['name'] : null,
            isset($field['label']) ? $field['label'] : null, [
                'class' => isset($field['labclass']) ? $field['labclass'] : null
            ]
        );


        $formField .= '<div id="subjectTable">';
        $formField .= '</div></div>';


        return $formField;
    }
}

if (!function_exists('imageField')) {
    function imageField($field)
    {
        $Sl = 1;
        $formField = '';
        $formField .= '<div id="" class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';


        $formField .= '<div id="imgLoading" hidden style="text-align: center;">';
        $formField .= '<img  src="/Image/select.gif">';
        $formField .= '</div></div>';


        return $formField;
    }
}


if (!function_exists('grImage')) {
    function grImage($field)
    {

        $formField = '';
        $formField .= '<div id="" class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';


        $formField .= '<div id="guardianImg" style="text-align: center;">';
        $formField .= '</div></div>';


        return $formField;
    }
}

if (!function_exists('marksTypeTable')) {

    function marksTypeTable($field)
    {
//                dd($field['value'][1]);


        $Sl = 1;
        $formField = '';
        $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
        $formField .= Form::label(
            isset($field['name']) ? $field['name'] : null,
            isset($field['label']) ? $field['label'] : null, [
                'class' => isset($field['labclass']) ? $field['labclass'] : null
            ]
        );
        $table = '<table border="1">';
        $table .= '<tr style="text-align: center; background-color: #3C8DBC; color:white;">';
        $table .= '<th> Sl </th><th>Select</th><th style="text-align: center;"> Mark Type </th><th style="text-align: center;">Total</th><th style="text-align: center;">Pass Mark</th>';
        $table .= '</tr>';

        $markT = \App\Models\Marks\MarksType::all();
        $markTypes = $markT->where('deleted_at', NULL);
        if (!$markTypes->isEmpty()) {

            foreach ($markTypes as $markType) {

                $markTypeName = isset($markType->marks_type) ? $markType->marks_type : null;
                $markTypeId = isset($markType->id) ? $markType->id : null;
                $table .= '<tr style="text-align: center;">';
                $table .= '<td>' . $Sl++ . '</td><td>' . Form::checkbox('subject_marks_type[' . $markType->id . ']', $markTypeId, isset($field['value'][$markType->id]->markTypeMax) && isset($field['value'][$markType->id]->markTypePass) ? true : false) . '</td>
                <td>' . $markTypeName . '</td><td>' .
                    Form::text('max_marks[' . $markType->id . ']', isset($field['value'][$markType->id]->markTypeMax) ? $field['value'][$markType->id]->markTypeMax : 0, isset($field['others']) ? $field['others'] : []) .
                    '</td><td>' .
                    Form::text('pass_no[' . $markType->id . ']', isset($field['value'][$markType->id]->markTypePass) ? $field['value'][$markType->id]->markTypePass : 0, isset($field['others']) ? $field['others'] : []) .
                    '</td>';
                $table .= '</tr>';
//              dd($field['value'][$markType->id]->markTypeMax);
            }

        }

        $table .= '</table> </div>';
//        dd($formField . $table);
        return $formField . $table;
    }

}

function marksTypeField($field, $languages)
{

    $languages = config('app.locales');
    $lang_def = 'en';
    $formFields = '';
    foreach ($field['value'] as $types) {
        foreach ($types as $type) {
//            dd($type);
            switch (isset($type['type']) ? $type['type'] : 'invalid') {
                case 'label':
//                dd($type);
                    $formFields .= function_exists('fieldLabel') ? fieldLabel($type) : null;
//                dd($formFields);
                    break;
                case 'text':
                    $formFields .= function_exists('fieldText') ? fieldText($type, $languages) : null;
//                dd($formFields);
                    break;
                case 'textarea':
                    $formFields .= function_exists('fieldTextArea') ? fieldTextArea($type, $languages) : null;
                    break;
                case 'select':
                    $formFields .= function_exists('fieldSelect') ? fieldSelect($type, $languages) : null;
                    break;
                case 'checkbox':
                    $formFields .= function_exists('fieldCheckBoxForSalary') ? fieldCheckBoxForSalary($type) : null;
                    break;
                case 'radio':
                    $formFields .= function_exists('fieldRadio') ? fieldRadio($type) : null;
                    break;
                case 'email':
                    $formFields .= function_exists('fieldEmail') ? fieldEmail($type) : null;
                    break;
                case 'file':
                    $formFields .= function_exists('fieldFile') ? fieldFile($type) : null;
                    break;
                case 'password':
                    $formFields .= function_exists('fieldPassword') ? fieldPassword($type) : null;
                    break;
                case 'number':
                    $formFields .= function_exists('fieldNumber') ? fieldNumber($type) : null;
                    break;
                case 'date':
                    $formFields .= function_exists('fieldDate') ? fieldDate($type) : null;
                    break;
                case 'hidden':
                    $formFields .= function_exists('fieldHidden') ? fieldHidden($type) : null;
                    break;
                case 'submit':
                    $formFields .= function_exists('formSubmit') ? formSubmit($type) : null;
                    break;
                case 'startrow':
                    $formFields .= function_exists('startRow') ? startRow() : null;
                    break;
                case 'endrow':
                    $formFields .= function_exists('endRow') ? endRow() : null;
                    break;
            }
        }

    };

    return $formFields;

}

function salaryField($field, $languages)
{

    $languages = config('app.locales');
    $lang_def = 'en';
    $formFields = '';
    foreach ($field['value'] as $types) {
        foreach ($types as $type) {
//            dd($type);
            switch (isset($type['type']) ? $type['type'] : 'invalid') {
                case 'label':
//                dd($type);
                    $formFields .= function_exists('fieldLabel') ? fieldLabel($type) : null;
//                dd($formFields);
                    break;
                case 'text':
                    $formFields .= function_exists('fieldText') ? fieldText($type, $languages) : null;
//                dd($formFields);
                    break;
                case 'textarea':
                    $formFields .= function_exists('fieldTextArea') ? fieldTextArea($type, $languages) : null;
                    break;
                case 'select':
                    $formFields .= function_exists('fieldSelect') ? fieldSelect($type, $languages) : null;
                    break;
                case 'checkbox':
                    $formFields .= function_exists('fieldCheckBoxForSalary') ? fieldCheckBoxForSalary($type) : null;
                    break;
                case 'radio':
                    $formFields .= function_exists('fieldRadio') ? fieldRadio($type) : null;
                    break;
                case 'email':
                    $formFields .= function_exists('fieldEmail') ? fieldEmail($type) : null;
                    break;
                case 'file':
                    $formFields .= function_exists('fieldFile') ? fieldFile($type) : null;
                    break;
                case 'password':
                    $formFields .= function_exists('fieldPassword') ? fieldPassword($type) : null;
                    break;
                case 'number':
                    $formFields .= function_exists('fieldNumber') ? fieldNumber($type) : null;
                    break;
                case 'date':
                    $formFields .= function_exists('fieldDate') ? fieldDate($type) : null;
                    break;
                case 'hidden':
                    $formFields .= function_exists('fieldHidden') ? fieldHidden($type) : null;
                    break;
                case 'submit':
                    $formFields .= function_exists('formSubmit') ? formSubmit($type) : null;
                    break;
                case 'startrow':
                    $formFields .= function_exists('startRow') ? startRow() : null;
                    break;
                case 'endrow':
                    $formFields .= function_exists('endRow') ? endRow() : null;
                    break;
            }
        }

    };

    return $formFields;

}

/**
 * @return string
 */

function startRow()
{
    $formField = '';

    return $formField .= '<div class="row">';

}


/**
 * @return string
 */

function endRow()
{
    $formField = '';

    return $formField .= '</div>';
}

/**
 * @param $field
 * @param $languages
 * @return string
 */

function fieldText($field, $languages)
{

    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';

    /*    $formField .= Form::label( isset($field['name']) ? $field['name'] : null,isset($field['label']) ? $field['label'] : null);
        dd($formField);*/

    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'id' => $field['name'] . '_1',
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
//    dd($formField);

    if (isset($field['trans']) && $field['trans'] == true) {
        foreach ($languages as $key => $value) {
            $formField .= '<div class="translation_wrap trans_' . $key . ' col-sm-11 trans_row">';
            $formField .= Form::text(
                isset($field['name']) ? $field['name'] . '_' . $key : null,
                isset($field['value']) ? $field['value'] : null,
                isset($field['others']) ? $field['others'] : []
            );

            $formField .= '</div>';
            $formField .= '<div class="translation_wrap trans_' . $key . ' ">';
            $formField .= Form::label(
                isset($field['name']) ? $field['name'] : null,
                $value, [
                    'class' => 'col-sm-1 text-blue',
                    'style' => 'height:35px;'
                ]
            );
            if (isset($field['prefix']) && !empty($field['prefix'])) {
                $formField .= '<span class="input-group-addon">' . $field['prefix'] . '</span>';
            }
            $formField .= '</div>';
        }
    } else {
        if (isset($field['prefix']) && !empty($field['prefix'])) {
            $formField .= '<span class="input-group-addon">' . $field['prefix'] . '</span>';
        }
        if (isset($field['others']['class'])) {
            $sntclass = isset($field['name']) ? $field['name'] : "";
            $field['others']['class'] = $field['others']['class'] . " " . $sntclass;
        }
        $formField .= Form::text(
            isset($field['name']) ? $field['name'] : null,
            isset($field['value']) ? $field['value'] : null,
            isset($field['others']) ? $field['others'] : []
        );
    }
    $formField .= '</div>';


    return $formField;

}

/**
 * @param $field
 * @param $languages
 * @return string
 */

function fieldTextArea($field, $languages)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    if (isset($field['trans']) && $field['trans'] == true) {

        foreach ($languages as $key => $value) {
            $formField .= '<div class="translation_wrap trans_' . $key . ' col-sm-11 trans_row">';
            $formField .= Form::textarea(
                isset($field['name']) ? $field['name'] . '_' . $key : null,
                isset($field['value']) ? $field['value'] : null,
                isset($field['others']) ? $field['others'] : []
            );
            $formField .= '</div>';
            $formField .= '<div class="translation_wrap trans_' . $key . ' ">';
            $formField .= Form::label(
                isset($field['name']) ? $field['name'] : null,
                $value, [
                    'class' => 'col-sm-1 text-blue',
                    'style' => ' height:35px;'
                ]
            );
            $formField .= '</div>';
        }
    } else {
        $formField .= Form::textarea(
            isset($field['name']) ? $field['name'] : null,
            isset($field['value']) ? $field['value'] : null,
            isset($field['others']) ? $field['others'] : []
        );
    }
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @param $languages
 * @return string
 */

function fieldSelect($field, $languages)
{
    //Select method signature
    /*select($name,$list = [],$selected = null,array $selectAttributes = [],array $optionsAttributes = [])*/

    //  dd($field);


    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
//    if(isset($field['multi']) && $field['multi'] == true){
//        $multiple = '';
//    }
    if (isset($field['trans']) && $field['trans'] == true) {
        foreach ($languages as $key => $value) {
            $formField .= '<div class="translation_wrap trans_' . $key . ' col-sm-10">';
            $formField .= Form::select(
                isset($field['name']) ? $field['name'] . '_' . $key : null,
                isset($field['options']) ? $field['options'][$key] : [], null,
                isset($field['others']) ? $field['others'] : []
            );
            $formField .= '</div>';
            $formField .= '<div class="translation_wrap trans_' . $key . ' ">';
            $formField .= Form::label(
                isset($field['name']) ? $field['name'] : null,
                $value, [
                    'class' => 'col-sm-1 text-blue',
                    'style' => ' height:35px;'
                ]
            );
            $formField .= '</div>';
        }
    } else {

        $options = $field['options'] ? count($field['options']) : 0;

        if ($options <= -2) {
            $flag = false;
            foreach ($field['options'] as $k => $v) {
                if ($flag) {
                    $formField .= Form::select(
                        isset($field['name']) ? $field['name'] : null,
                        isset($field['options']) ? $field['options'] : [],
                        $k ?? null,
                        isset($field['others']) ? $field['others'] : [],
                        isset($field['optionsAttribute']) ? $field['optionsAttribute'] : []
                    );
                }
                $flag = true;
            }
        } else {
            $formField .= Form::select(
                isset($field['name']) ? $field['name'] : null,
                isset($field['options']) ? $field['options'] : [],
                isset($field['value']) ? $field['value'] : null,
                isset($field['others']) ? $field['others'] : [],
                isset($field['optionsAttribute']) ? $field['optionsAttribute'] : []

            );
        }

        /* $tax_attributes = collect($all_taxes->get())
             ->mapWithKeys(function ($item) {
                 return [$item->id => ['data-rate' => $item->amount, 'data-type' => $item->type ]];
             })->all();*/

        //  $optionsAttributes = [134 => ['data-rate' => 10], 2 => ['data-rate' => 18], 5 => ['data-rate' => 18] ];

    }
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldCheckBox($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    if (isset($field['check'])) {
        foreach ($field['check'] as $name => $value) {
            $formField .= Form::checkbox($name, $value, $field['bool']) . '  ' . studly_case($value);;
            $formField .= '<br>';
        }
    } else {
        $formField = '<strong>check</strong> is not defined';
    }
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */
function fieldCheckBoxForSalary($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    if (isset($field['check'])) {
        foreach ($field['check'] as $name => $value) {
            $formField .= Form::checkbox($name, $value, $field['bool']) . '  ' . ucwords(str_replace('_', ' ', $name));
            /*$formField .= '<br>';*/
        }
    } else {
        $formField = '<strong>check</strong> is not defined';
    }
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldRadio($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );


    if (isset($field['radval'])) {
        foreach ($field['radval'] as $key => $radValue) {//key true(1) or false(0) | value is active or inactive
            $checked = false;

            if (isset($field['value']) && $key == $field['value']) {
                $checked = true;
            } elseif (isset($field['checked']) && $key == $field['checked']) {//this is for old active inactive rad valu option. will remove later when we will do all radvalue with new o or 1
                $checked = true;
            }


            //Form::radio('name', 'value', true);
            $formField .= Form::radio(
//                    isset($field['name']) ? $field['name'] : null, $radValue, isset($field['checked']) ? $field['checked'] : null
                    isset($field['name']) ? $field['name'] : null, $key, $checked
                ) . '  ' . ucwords($radValue);

            // dd($radValue);
        }
    } else {
        $formField = '<strong>radval</strong> is not defined';
    }
    $formField .= '</div>';


//    dd($formField);
    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldEmail($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    $formField .= Form::email(
        isset($field['name']) ? $field['name'] : null,
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '</div>';

    return $formField;

}

function fieldFile($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' " id = "filediv">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    $formField .= Form::file(
        isset($field['name']) ? $field['name'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '</div>';

    return $formField;

}

/**
 * @param $field
 * @return string
 */

function fieldPassword($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    $formField .= Form::password(
        isset($field['name']) ? $field['name'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '<br>';
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldNumber($field)
{

    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    $formField .= Form::number(
        isset($field['name']) ? $field['name'] : null,
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );


    $formField .= '<br>';

    if ($field['div']) {
        $formField .= '<div id="' . $field['name'] . '-div"></div>';
    }

    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldDate($field)
{
    $formField = '';
    $formField .= '<div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['label']) ? $field['label'] : null, [
            'class' => isset($field['labclass']) ? $field['labclass'] : null
        ]
    );
    $formField .= Form::date(
        isset($field['name']) ? $field['name'] : null,
        /*\Carbon\Carbon::now(),*/
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '<br>';
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldHidden($field)
{
    $formField = '';
    $formField .= Form::hidden(
        isset($field['name']) ? $field['name'] : null,
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function formSubmit($field)
{
    $formField = '';
    // $formField .= '<br>';
    $formField .= '<div class="submig_button">';
    $formField .= Form::submit(
        isset($field['label']) ? $field['label'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '</div>';

    return $formField;
}

/**
 * @param $field
 * @return string
 */

function fieldLabel($field)
{
    $formField = '';
    $formField .= '<br><div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '</div><br>';

    return $formField;
}

function fieldLabel2($field)
{
    $formField = '';
    $formField .= '<br><div class="field_wrap ' . (isset($field['wrapclass']) ? $field['wrapclass'] : null) . ' ">';
    $formField .= Form::label(
        isset($field['name']) ? $field['name'] : null,
        isset($field['value']) ? $field['value'] : null,
        isset($field['others']) ? $field['others'] : []
    );
    $formField .= '</div><br>';

    return $formField;
}


/**
 * @param $formFields
 * @return string
 */

function formFields($formFields, $mode = null, $id = null)
{

    $id = isset($id) ? $id : null;
    $mode = isset($mode) ? $mode : null;
//    dd($mode);
    $hiddenField = inputField(['type' => 'startrow']);

    $hiddenField .= inputField([
        'type' => 'hidden',
        'name' => $formFields->fieldName(),
        'value' => $formFields->currentClass()
    ]);

    $hiddenField .= inputField(['type' => 'endrow']);

//    dd($formFields->filteredForm($id, $mode));
//    dd($formFields);

    $inputField = '';
    foreach ($formFields->filteredForm($id, $mode) as $field) {
//        dd($field);

        $requred_cls = '';
        if (isset($field['validation']) && $field['label'] != '&nbsp;') {
            if ($is_required = strpos($field['validation'], 'quired')) {
                $requred_cls = '*';
            }
        }
        $inputField .= inputField(['type' => 'startrow']);

        $inputField .= inputField([
            'type' => isset($field['type']) ? $field['type'] : null,
            'name' => isset($field['name']) ? $field['name'] : null,
            'label' => isset($field['label']) ? $field['label'] . $requred_cls : null,
            'div' => isset($field['div']) ? $field['div'] : null,
            'value' => isset($field['value']) ? $field['value'] : null,
            'labclass' => isset($field['labclass']) ? $field['labclass'] : null,
            'wrapclass' => isset($field['wrapclass']) ? $field['wrapclass'] : null,
            'trans' => isset($field['trans']) ? $field['trans'] : null,
            'options' => isset($field['options']) ? $field['options'] : null,
            'optionsAttribute' => isset($field['optionsAttribute']) ? $field['optionsAttribute'] : null,
            'bool' => isset($field['bool']) ? $field['bool'] : null,
            'checked' => isset($field['checked']) ? $field['checked'] : null,
            'radval' => isset($field['radval']) ? $field['radval'] : null,
            'check' => isset($field['check']) ? $field['check'] : null,
            'validation' => isset($field['validation']) ? $field['validation'] : null,
            'prefix' => isset($field['prefix']) ? $field['prefix'] : null,
            'others' => isset($field['others']) ? $field['others'] : [],
            'role' => isset($field['role']) ? $field['role'] : null,

        ]);
        $inputField .= inputField(['type' => 'endrow']);
    }

//    dd($inputField);

    return $hiddenField . $inputField;
}


/**
 * called from the blade page where list is shown in a table
 * @param $usersList
 * @param $locale
 * @param $defaultLoacle
 * @param $dataArr
 * @return string
 */
function dataTableList($list = null, $locale = null, $defaultLoacle = null, $model = null)
{

    $req = request()->segment(1);

    $infoList = $list->tbodyValues($model);
    $dataArr = $list->dataArr;
    $dataList = "<table  id='example1' class=' table-stripped' style='overflow-y: scroll' >";
    $dataList .= '<tr>';
    $SL = 1;

    $dataList .= "<th>SL</th>";
    //for th values to display
    //$keys are th values
    foreach ($dataArr as $key => $val):

        if (!is_array($val) || (is_array($val) && count($val) > 0))
            $dataList .= "<th>$key</th>";

    endforeach;
    $dataList .= "<th>Action</th>";
    $dataList .= '</tr>';

    //for dilplaying dynamic relevant td values from database
    foreach ($infoList as $info):

        $dataList .= '<tr>';
        $dataList .= "<td>" . $SL++ . "</td>";

        //$keys are th values
        //$vals are td values if not array themselves
//        dd($dataArr);
        foreach ($dataArr as $key => $val):


            if (is_array($val)):
                //for td values from related table
                //$ks(relational function name in the model) are the keys of $val  if $val is array
                //$vs(field name of the related table) are the values of $val if $val is array
//                dd($val);
                foreach ($val as $k => $v):
//dd($info->designation);
                    if (isset($info->$k->$v)):
                        $data = $info->$k->$v;
                    endif;
                    $dataList .= "<td>" . $data . "</td>";

                endforeach;
            //for td values from main table
            elseif (!is_array($val) && $val != ''):
                $dataList .= "<td>" . $info->$val . "</td>";
            elseif ($val == ''):
                $dataList .= "<td><span class='glyphicon glyphicon-user fa-man' aria-hidden='true'></span></td>";

            endif;
        endforeach;

        $dataList .= ' <td>';

        $dataList .= '<a class="btn btn-primary btn-xs mrg" data-original-title="View" data-toggle="tooltip" href="' . url($req . '/view/' . $info->id) . '"><i class="fa fa-check-square-o"></i></a>';
        $dataList .= '<a class="btn btn-warning btn-xs mrg" data-original-title="Edit" data-toggle="tooltip" href=" ' . url($req . '/edit/' . $info->id) . ' "><i class="fa fa-edit"></i></a>';
        $dataList .= '<a  class="btn btn-danger btn-xs mrg" data-original-title="Delete" data-toggle="tooltip" href=" ' . url($req . '/delete/' . $info->id) . ' "><i class="fa fa-trash-o"></i></a>';

        $dataList .= ' </td>';

        $dataList .= '</tr>';

    endforeach;

    $dataList .= '</table>';

    return $dataList;
}

/**
 * get the year list
 * @return string
 */

function yearList()
{
    $year = '<select name="year" id="year"><option>Select Year</option>';

    $starting_year = date('Y', strtotime('-10 year'));
    $ending_year = date('Y', strtotime('+10 year'));
    $current_year = date('Y');

    for ($starting_year; $starting_year <= $ending_year; $starting_year++) {

        $year .= '<option value=' . $starting_year . ' >' . $starting_year . '</option>';
    }

    $year .= '</select>';

    return $year;
}

/**
 * get the month list for holidays
 * @return string
 */
function monthsList()
{

    $list = yearList() . '<ul class=" nav nav-pills nav-stacked">';
    for ($m = 1; $m <= 12; $m++) {
        $month = date("F", mktime(0, 0, 0, $m));
        $list .= "<li class='active month' value='$m' ><a href='#'><i class='fa fa-calendar'></i>$month</a></li>";
    }
    $list .= "</ul>";

    return $list;

}

/**
 * get monthlist for getting timesheet report
 * @return string
 */
function monthsListForTimesheet()
{

    $list = "<select name='month'><option >Select Month</option>";
    for ($m = 1; $m <= 12; $m++) {
        $month = date("F", mktime(0, 0, 0, $m));
        $list .= "<option  value='$m' >$month</option>";
    }
    $list .= "</select>";

    return $list;

}

function is_json($string, $return_data = false)
{
    $data = json_decode($string);
    return (json_last_error() == JSON_ERROR_NONE) ? ($return_data ? $data : TRUE) : FALSE;
}

/**
 * @param null $menus
 * @param int $id_parent
 * @return array
 */
function getAllMenuIdsForTheLoggedUser($menus = null, $id_parent = 0)
{
    $exploded_sub_module_ids_for_user = null;
    $user_type = Session::get('USER_TYPE');
    $final_sm_ids = [];
    $menu_for = [];

    $site_id = Session::get('SITE_ID');
    $site_group_id = Session::get('SITE_GROUP_ID');


    if ($user_type == 'eduworld') {
            if ($site_id) {//edu user impersonate to site
                $menu_for = ['site', 'ecsgs', 'ecsg', 'ec', 'all'];

                /*          $site_info = SiteInfo::findOrFail($site_id);
                          $package = EduPackage::whereId($site_info->siteMembership->edu_package_id ?? null)->first();
                          $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];
                          $assigned_package_sub_module_ids = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();

                          $final_sm_ids = $assigned_package_sub_module_ids;*/


                $displayable = $menus->where('is_displayable', 1)
                        ->whereIn('menu_for', $menu_for)
                        ->pluck('id')->toArray() ?? null;

                $parent_ids = array_unique($menus->whereIn('id', $displayable)->pluck('parent_id')->toArray() ?? []);
                $parent_parent_ids = array_unique($menus->whereIn('id', $parent_ids)->pluck('parent_id')->toArray() ?? []);
                $parent_id_merged = array_merge($parent_ids, $parent_parent_ids, $displayable);

                return $parent_id_merged;


            } else if ($site_group_id) {
                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];

                $site_group = GlobalSiteGroup::whereId($site_group_id)->first();
                $package_module_ids = EduPackageModule::where('edu_package_id', ($site_group->edu_package_id ?? 0))->pluck('module_id');
                $final_sm_ids = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();


            } else {
                $menu_for = ['eduworld', 'ecsgs', 'ecsg', 'ec', 'all', 'none'];


                $displayable = $menus->where('is_displayable', 1)
                        ->whereIn('menu_for', $menu_for)
                        ->pluck('id')->toArray() ?? null;

                $parent_ids = array_unique($menus->whereIn('id', $displayable)->pluck('parent_id')->toArray() ?? []);
                $parent_parent_ids = array_unique($menus->whereIn('id', $parent_ids)->pluck('parent_id')->toArray() ?? []);
                $parent_id_merged = array_merge($parent_ids, $parent_parent_ids, $displayable);
//                dd($parent_id_merged);

                return $parent_id_merged;
            }

    } else if ($user_type == 'site_group') {

                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];

                $site_group = GlobalSiteGroup::whereId($site_group_id)->first();
                $package_module_ids = EduPackageModule::where('edu_package_id', ($site_group->edu_package_id ?? null))->pluck('module_id');
                $assigned_package_sub_module_ids = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
                $final_sm_ids = $assigned_package_sub_module_ids;



    } else if ($user_type == 'site') {

        $site_info = SiteInfo::whereId($site_id)->first();
        // $site_access_sm_ids = $site_info->subModules()->pluck('sub_module_id')->toArray() ?? [];
        $package = EduPackage::whereId($site_info->siteMembership->edu_package_id ?? null)->first();
        $package_module_ids = $package ? ($package->modules->pluck('id')->toArray()) : [];
        $assigned_package_sub_modules = SubModule::whereIn('module_id', $package_module_ids)->pluck('id')->toArray();
        // $unique_package_and_site_accesses_sm_ids = array_intersect($site_access_sm_ids, $assigned_package_sub_modules);


        $user_assigned_sm_ids = array_unique(request()->user()->getSubModules());
        $extra_permission_sm_ids = (UserExtraPermission::whereUserId(Auth::user()->id)->first()->sub_module_ids) ?? null;
        $exploded_extra_permission_sm_ids = $extra_permission_sm_ids ? explode(',', $extra_permission_sm_ids) : [];
        $unique_merged_assigned_and_extra_sm_ids = array_unique(array_merge($user_assigned_sm_ids, $exploded_extra_permission_sm_ids));


        if (request()->user()->hasSiteRole('admin')) {
            $menu_for = ['site', 'es', 'ecs', 'all'];
            $final_sm_ids = $assigned_package_sub_modules;

        } else {

                $menu_for = ['site', 'es', 'ecs', 'all'];
                $final_sm_ids = array_intersect($assigned_package_sub_modules, $unique_merged_assigned_and_extra_sm_ids);

        }
    }
//==================END====================

    if (count($final_sm_ids) > 0) {

        $subModuleArray = array_values(array_filter(SubModule::whereIn('id', $final_sm_ids)->pluck('menu_ids')->toArray() ?? null));
        $parent_id_final = [];

        //   dd($final_sm_ids);
        // dd($subModuleArray[14]);
//
        if (count($subModuleArray) > 0) {
            foreach ($subModuleArray as $k => $value) {

                if ($value) {

                    $exploded = explode(',', $value) ?? [];
                    $displayable = $menus->whereIn('id', $exploded)->whereIn('menu_for', $menu_for)->where('is_displayable', 1)->pluck('id')->toArray() ?? null;
                    $parent_ids = array_unique($menus->whereIn('id', $displayable)->pluck('parent_id')->toArray() ?? []);
                    $parent_parent_ids = array_unique($menus->whereIn('id', $parent_ids)->pluck('parent_id')->toArray() ?? []);

                    $parent_id_merged = array_merge($parent_ids, $parent_parent_ids, $displayable);
                    $parent_id_final = array_unique(array_merge($parent_id_final, $parent_id_merged));

                    //  Log::info($displayable);

                    /*if($k==8){
                         dd($exploded);
                     }*/
                }
            }


        }


        $get_common_menus_ids_for_logged_in_user = getCommonMenuIdsForLoggedUser();
        //    dd($get_common_menus_ids_for_logged_in_user);
        $parent_id_final = array_unique(array_merge($parent_id_final, $get_common_menus_ids_for_logged_in_user));

        return $parent_id_final;
    }
}

function displayableMenus($model = null, $parent_id = 0, $permitted_menus = null, $display = true, $status = true)
{
    $displayedMenus = null;

    if ($model && $permitted_menus) {
        $displayedMenus = $model
            ->whereParentId($parent_id)
            ->whereIsDisplayable($display)
            ->whereStatus($status)
            ->whereIn('id', $permitted_menus)
            ->orderBy('position')
            ->get();

        return $displayedMenus;
    }
}

function getCommonMenuIdsForLoggedUser()
{
    $menus = new \App\Models\Menu\Menu();
    $commonMenus = $menus
        ->where('is_logged_common_access', 1)
        ->where('is_displayable', 1)
        ->pluck('id')
        ->toArray();


    $common_parent_ids = array_unique(
        $menus->whereIn('id', $commonMenus)
            ->where('is_logged_common_access', 1)
            ->where('is_displayable', 1)
            ->pluck('parent_id')
            ->toArray() ?? []);

    $common_parent_parent_ids = array_unique(
        $menus->whereIn('id', $common_parent_ids)
            ->where('is_logged_common_access', 1)
            ->where('is_displayable', 1)
            ->pluck('parent_id')
            ->toArray() ?? []);

    $parent_id_final = array_unique(array_merge($commonMenus, $common_parent_ids, $common_parent_parent_ids));
    $final_array = array_filter($parent_id_final, function ($a) {
        return ($a !== 0);
    });

//     dd($commonMenus);

    return $final_array;


}


function getChildMenus($model = null, $id_parent = 0, $display = true, $status = true)
{

    $displayedMenus = $model->whereParentId($id_parent)
        ->whereIsDisplayable($display)
        ->whereStatus($status)
        ->get();

    $menus = [];

    foreach ($displayedMenus as $dm) {
        if (!$dm->is_common_access) {
            $menus[] = $dm;
        }
    }

//  dd($menus);
    return $menus;
}

function isAccessable($model = null, $roleId = null, $menuId = null/*, $siteId = 1*/)
{


    $siteId = (int)\Illuminate\Support\Facades\Session::get(SITE_ID);

    $isAccessable = $model
//        ->whereRoleId($roleId)->whereMenuId($menuId)->wherSiteId($siteId)->first();
        ->whereRoleId($roleId)->whereMenuId($menuId)->first();
//dd($isAccessable->view == true);
    return $isAccessable;
}

function generateSideBar()
{


    if (!file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS')))) {
        mkdir(base_path("resources/views/default/sidebars/" . Session::get('ALIAS')), 0777, true);
        generateSideBar();
    } else {


        if (!file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'))) {
//            dd('2');
            $menus = new \App\Models\Menu\Menu();
            $permitted_menu_ids = getAllMenuIdsForTheLoggedUser($menus);
            $displayedMenus = displayableMenus($menus, 0, $permitted_menu_ids);
//            dd($displayedMenus);


            $html = '<ul class="sidebar-menu"> <!--<li class="header">Dashboard</li>-->';
            $hash = "#";
            $log = new Log();


            if (!empty($displayedMenus)) {
                foreach ($displayedMenus as $K => $displayedMenu) {
                    $displayedChildMenus = displayableMenus($menus, $displayedMenu->id, $permitted_menu_ids);

                    if (isset($displayedChildMenus) && count($displayedChildMenus) > 0) {
                        $html .= '<li class="parent_menu_class treeview">';
                    } else {
                        $html .= '<li class="">';
                    }
                    if (Route::has($displayedMenu->route_name)) {

                        //dd(URL::route($displayedMenu->route_name, array(), false));
                        // $html .= '<a href="' . route($displayedMenu->route_name) . '" >';
                        $html .= '<router-link to="' . URL::route($displayedMenu->route_name, array(), false) . '">';
                    } else {
                        $html .= '<router-link to="">';
                    }
                    $html .= '<i class="';
                    if (isset($displayedMenu->icon_name) && !empty($displayedMenu->icon_name)) {
                        $html .= $displayedMenu->icon_name;
                    } else {
                        $html .= 'fa fa-users';
                    }
                    $html .= '"></i><span>' . $displayedMenu->menu_name . '</span>';
                    if (isset($displayedChildMenus) && count($displayedChildMenus) > 0) {
                        $html .= '<i class="fa fa-angle-left pull-right"></i>';
                    }
                    $html .= '</router-link>';

                    if (isset($displayedChildMenus) && count($displayedChildMenus) > 0) {
                        $html .= '<ul class="treeview-menu" >';
                        foreach ($displayedChildMenus as $displayedChildMenu) {
                            $displayedSubChildMenus = displayableMenus($menus, $displayedChildMenu->id, $permitted_menu_ids);

                            if (isset($displayedSubChildMenus) && count($displayedSubChildMenus) > 0) {
                                $html .= '<li class="parent_menu_class treeview">';
                                $html .= '<a href="#"><i class="';
                                if (isset($displayedChildMenu->icon_name) && !empty($displayedChildMenu->icon_name)) {
                                    $html .= $displayedChildMenu->icon_name;
                                } else {
                                    $html .= 'fa fa-users';
                                }
                                $html .= '"></i><span>' . $displayedChildMenu->menu_name . '</span>';
                                if (isset($displayedSubChildMenus) && count($displayedSubChildMenus) > 0) {
                                    $html .= '<i class="fa fa-angle-left pull-right"></i>';
                                }
                                $html .= '</a>';
                                $html .= '<ul class="treeview-menu">';
                                foreach ($displayedSubChildMenus as $displayedSubChildMenu) {
                                    $html .= '<li class="child_menu_class" >';
                                    if (Route::has($displayedSubChildMenu->route_name)) {
                                        // $html .= '<a href="' . route($displayedSubChildMenu->route_name) . '" >';
                                        $html .= '<router-link to="' . URL::route($displayedSubChildMenu->route_name, array(), false) . '">';

                                    } else {
                                        $html .= '<a href="#">';
                                    }
                                    $html .= '<i class="';
                                    if (isset($displayedSubChildMenu->icon_name) && !empty($displayedSubChildMenu->icon_name)) {
                                        $html .= $displayedSubChildMenu->icon_name;
                                    } else {
                                        $html .= 'fa fa-users';
                                    }
                                    $html .= '"></i >' . $displayedSubChildMenu->menu_name . '</a >';
                                    $html .= '</li >';

                                }
                                $html .= '</ul>';
                                $html .= '</li>';
                            } else {
                                $html .= '<li class="child_menu_class">';
                                if (Route::has($displayedChildMenu->route_name)) {
                                    // $html .= '<a href="' . route($displayedChildMenu->route_name) . '" >';
                                    $html .= '<router-link to="' . URL::route($displayedChildMenu->route_name, array(), false) . '">';

                                } else {
                                    $html .= '<a href="#">';
                                }
                                $html .= '<i class="';
                                if (isset($displayedChildMenu->icon_name) && !empty($displayedChildMenu->icon_name)) {
                                    $html .= $displayedChildMenu->icon_name;
                                } else {
                                    $html .= 'fa fa-users';
                                }
                                $html .= '"></i>' . $displayedChildMenu->menu_name;
                                $html .= '</a></li>';

                            }
                        }
                        $html .= '</ul>';
                    }
                    $html .= '</li>';
                }
                $html .= '</ul>';
            } else {

                $html .= '<li style="color:white">You don"t have any permission yet!</li></ul>';
            }

            file_put_contents(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id) . '.blade.php', $html);
        }

    }


    return null;
}


function cleanNonUnicodeSupport($pattern)
{
    if (!$pattern) {
        return false;
    }
    return preg_replace('/\\\[px]\{[a-z]{1,2}\}|(\/[a-z]*)u([a-z]*)$/i', '$1$2', $pattern);
}

function isEmail($email)
{
    return !empty($email) && preg_match(cleanNonUnicodeSupport('/^[a-z\p{L}0-9!#$%&\'*+\/=?^`{}|~_-]+[.a-z\p{L}0-9!#$%&\'*+\/=?^`{}|~_-]*@[a-z\p{L}0-9]+(?:[.]?[_a-z\p{L}0-9-])*\.[a-z\p{L}0-9]+$/ui'), $email);
}


function rearrangeSiteUserRolesAccess($site_id, $roles_array)
{

    if (count($roles_array)) {
        $s_sub_module_Ids = array_unique(\App\Models\Site\Access\GlobalSiteAccess::where('site_id', $site_id)->pluck('sub_module_id')->toArray()) ?? [];

        foreach ($roles_array as $k => $v) {
            $s_role_access = \App\Models\Site\Permission\SiteRoleAccess::where('site_role_id', $v)->first();

            if ($s_role_access) {
                $exploded_s_m = explode(',', $s_role_access->sub_module_ids ?? null) ?? [];
                $result = array_intersect($s_sub_module_Ids, $exploded_s_m);
                $s_role_access->sub_module_ids = implode(',', $result) ?? [];
                $s_role_access->save();
            }

        }
    }

}


function getActiveInactive($value)
{
    if ($value) {
        return 'Active';
    } elseif ($value == 0) {
        return 'Inactive';
    } else {
        return 'Not Found';

    }
}

function addOrdinalNumberSuffix($num)
{
    if (!in_array(($num % 100), array(11, 12, 13))) {
        switch ($num % 10) {
            // Handle 1st, 2nd, 3rd
            case 1:
                return $num . 'st';
            case 2:
                return $num . 'nd';
            case 3:
                return $num . 'rd';
        }
    }
    return $num . 'th';
}

function getSiteName($lang = null)
{

    $site_name = SiteInfo::findOrFail(Session::get('SITE_ID'));
    if ($lang) {
        $response = $site_name->translate($lang)->short_name ?? $site_name->short_name;
    } else {
        $response = $site_name->short_name;
    }

    return $response;
}


function getSiteInfoForPdf()
{

    $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));
    return $the_site;
}

function getYesNo($value)
{
    if ($value) {
        return 'Yes';
    } elseif ($value == 0) {
        return 'No';
    } else {
        return 'Not Found';

    }
}

function getLateIntime($value)
{
    if ($value) {
        return 'Late';


    } else {
        return 'InTime';
    }
}


function deleteDir($dir)
{
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                if (is_dir($dir . "/" . $object)) {
                    deleteDir($dir . "/" . $object);
                } else {
                    unlink($dir . "/" . $object);
                }
            }
        }
        rmdir($dir);
    }
}


function getAllAcademicGroupsBySite($site_id)
{


    $result = null;
    $get_acc_group_ids = [];

    if (request()->user()->roles[0]->key == 'student') {
        $get_acc_group_ids = [request()->user()->academic_group_id ?? ""];
    } else {
        $get_acc_group_ids = \App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting::whereSiteId($site_id)->pluck('academic_group_id');
    }


    if ($get_acc_group_ids) {
        $acc_gr = \App\Models\Academic\AcademicGroup::whereIn('id', $get_acc_group_ids)->get();
        if (count($acc_gr)) {
            $result = $acc_gr;
        }
    }
    return $result;
}

function academicGroupsBySiteGroup($site_group_id)
{

    $result = null;
    $get_acc_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('academic_group_id');
    if ($get_acc_group_ids) {
        $acc_gr = \App\Models\Academic\AcademicGroup::whereIn('id', $get_acc_group_ids)->get();
        if (count($acc_gr)) {
            $result = $acc_gr;
        }
    }
    return $result;
}

function arrayToString($data)
{
    $out = $sep = '';
    if (is_array($data)) {
        foreach ($data as $key => $value) {
            $out .= $sep . $key . ':' . $value;
            $sep = ', ';
        }
    }
    return $out;
}


function getForAlias()
{

    $user_type = Session::get('USER_TYPE');
    $site_id = Session::get('SITE_ID');
    $site_group_id = Session::get('SITE_GROUP_ID');
    $company_id = Session::get('COMPANY_ID');
    $menu_for = [];


    if ($user_type == 'eduworld') {

        if (request()->user()->hasEduRole('administrator')) {

            if ($site_id) {//edu user impersonate to site
                $menu_for = ['site', 'ecsgs', 'ecsg', 'ec', 'all'];


            } else if ($site_group_id) {
                $menu_for = ['site_group','ecsgs', 'ecsg', 'all'];


            } else if ($company_id) {
                $menu_for = ['company', 'ecsgs', 'ecsg', 'ec', 'all'];


            } else {//edu administrator without impersonation
                $menu_for = ['eduworld', 'ecsgs', 'ecsg', 'ec', 'all', 'none'];

            }

        } else {// edu role except administrator

            if ($site_id) {//edu user impersonate to site
                $menu_for = ['site', 'ecsgs', 'ecsg', 'ec', 'all'];

            } else if ($site_group_id) {
                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];

            } else if ($company_id) {
                $menu_for = ['company', 'ecsgs', 'ecsg', 'ec', 'all'];

            } else {//edu user (except administrator) without impersonate
                $menu_for = ['eduworld', 'ecsgs', 'ecsg', 'ec', 'all'];


            }
        }

    } else if ($user_type == 'company') {


        if (request()->user()->hasCompanyRole('superadmin')) {

            if ($site_id) {//edu user impersonate to site
                $menu_for = ['site', 'ecsgs', 'ecsg', 'all'];


            } else if ($site_group_id) {
                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];


            } else {//superadmin without impersonation
                $menu_for = ['company', 'ecsgs', 'ecsg', 'ec', 'all'];


            }

        } else {// role except superadmin

            if ($site_id) {//edu user impersonate to site
                $menu_for = ['site', 'ecsgs', 'ecsg', 'ec', 'all'];

            } else if ($site_group_id) {
                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];

            } else {//edu user (except administrator) without impersonate
                $menu_for = ['company', 'ecsgs', 'ecsg', 'ec', 'all'];

            }
        }


    } else if ($user_type == 'site_group') {

        if (request()->user()->hasSiteGroupRole('superadmin')) {
            if ($site_id) {
                $menu_for = ['site', 'ecsgs', 'all'];

            } else {//
                $menu_for = ['site_group', 'ecsgs', 'ecsg', 'all'];

            }


        } else {//not superadmin --site_group
            if ($site_id) {
                $menu_for = ['site', 'ecsgs', 'ecsg', 'all'];

            } else {//not superadmin no site impersonate --site_group
            }
        }


    } else if ($user_type == 'site') {

        if (request()->user()->hasSiteRole('admin')) {
            $menu_for = ['site', 'es', 'ecs', 'all'];

        } else {

            if (request()->user()->hasSiteRole('student')) {
                $menu_for = ['student', 'all'];


            } elseif (request()->user()->hasSiteRole('guardian')) {
                $menu_for = ['guardian', 'all'];
            } else {//except site admin,student, guardian
                $menu_for = ['site', 'es', 'ecs', 'all'];
            }


        }
    }

    return $menu_for;

}


function convertNumberToWord($number = false)
{
    $decimal = round($number - ($no = floor($number)), 2) * 100;
    $decimal_part = $decimal;
    $hundred = null;
    $hundreds = null;
    $digits_length = strlen($no);
    $decimal_length = strlen($decimal);
    $i = 0;
    $str = array();
    $str2 = array();
    $words = array(0 => '', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
        7 => 'seven', 8 => 'eight', 9 => 'nine',
        10 => 'ten', 11 => 'eleven', 12 => 'twelve',
        13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
    $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');

    while ($i < $digits_length) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
        } else $str[] = null;
    }

    $d = 0;
    while ($d < $decimal_length) {
        $divider = ($d == 2) ? 10 : 100;
        $decimal_number = floor($decimal % $divider);
        $decimal = floor($decimal / $divider);
        $d += $divider == 10 ? 1 : 2;
        if ($decimal_number) {
            $plurals = (($counter = count($str2)) && $decimal_number > 9) ? 's' : null;
            $hundreds = ($counter == 1 && $str2[0]) ? ' and ' : null;
            @$str2 [] = ($decimal_number < 21) ? $words[$decimal_number] . ' ' . $digits[$decimal_number] . $plural . ' ' . $hundred : $words[floor($decimal_number / 10) * 10] . ' ' . $words[$decimal_number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
        } else $str2[] = null;
    }

    $Rupees = implode('', array_reverse($str));
    $paise = implode('', array_reverse($str2));
    $paise = ($decimal_part > 0) ? $paise . ' Paisa' : '';
    return ($Rupees ? $Rupees . 'Taka ' : '') . $paise;
}


function convertNumberToWord1($num = false)
{
    $num = str_replace(array(',', ' '), '', trim($num));
    if (!$num) {
        return false;
    }
    $num = (int)$num;
    $words = array();
    $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
        'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
    );
    $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
    $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
        'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
        'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
    );
    $num_length = strlen($num);
    $levels = (int)(($num_length + 2) / 3);
    $max_length = $levels * 3;
    $num = substr('00' . $num, -$max_length);
    $num_levels = str_split($num, 3);
    for ($i = 0; $i < count($num_levels); $i++) {
        $levels--;
        $hundreds = (int)($num_levels[$i] / 100);
        $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
        $tens = (int)($num_levels[$i] % 100);
        $singles = '';
        if ($tens < 20) {
            $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
        } else {
            $tens = (int)($tens / 10);
            $tens = ' ' . $list2[$tens] . ' ';
            $singles = (int)($num_levels[$i] % 10);
            $singles = ' ' . $list1[$singles] . ' ';
        }
        $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
    } //end for loop
    $commas = count($words);
    if ($commas > 1) {
        $commas = $commas - 1;
    }
    return implode(' ', $words);
}





