<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteProtyonpotroSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_protyonpotro_settings', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('academic_group_id')->unsigned()->nullable();

            $table->string('user_type')->nullable();
            $table->string('logo_position')->nullable();
            $table->boolean('border_image_status')->default(0);
            $table->string('border_image')->nullable();
            $table->boolean('watermark_status')->default(0);
            $table->string('watermark_image')->nullable();
            $table->boolean('address_present_status')->default(0);
            $table->boolean('eiin_show_status')->default(0);
            $table->boolean('college_code_show_status')->default(0);
            $table->boolean('nu_code_show_status')->default(0);
            $table->boolean('written_by_show_status')->default(0);
            $table->boolean('parents_title_status')->default(0);
            $table->boolean('printed_date_show')->default(0);

            $table->string('initial_referance_prefix')->nullable();
            $table->string('initial_referance_number')->nullable();
            $table->string('initial_referance_suffix')->nullable();
            $table->string('referance_prefix')->nullable();
            $table->integer('referance_number')->nullable();
            $table->string('referance_suffix')->nullable();
            $table->longText('description')->nullable();

            $table->boolean('session_show_status')->default(0);
            $table->string('testimonial_background_color')->nullable();
            $table->boolean('exam_center_show_status')->default(0);
            $table->string('exam_center')->nullable();
            $table->string('exam_center_code')->nullable();

            $table->boolean('status')->default(1);
            $table->integer('site_id')->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_protyonpotro_settings');
    }
}
