<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddHalfDayLeaveCountToSiteEmployeePayrollTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_employee_payroll', function (Blueprint $table) {
            $table->boolean('half_day_leave_count')->default(0);
            $table->integer('countable_half_day_leave')->default(0);
            $table->integer('total_half_day_leave')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_employee_payroll', function (Blueprint $table) {
             $table->dropColumn('half_day_leave_count');
             $table->dropColumn('total_half_day_leave');
             $table->dropColumn('countable_half_day_leave');
        });
    }
}
