<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBookBorrowingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('book_borrowings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->unsignedInteger('member_id')->nullable();
            $table->unsignedInteger('book_id')->nullable();
            $table->date('borrowed_date')->nullable();
            $table->date('due_date')->nullable();
            $table->date('returned_date')->nullable();
            $table->text('notes')->nullable();
            $table->integer('site_id')->nullable();
            $table->string('status')->nullable();
            $table->string('returned_status')->nullable();
            $table->integer('renewals')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('book_borrowings');
    }
}
