<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdmissionPaymentSessionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('admission_payment_sessions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_board_approve_id');
            $table->dateTime('start_date_time')->nullable();
            $table->dateTime('end_date_time')->nullable();
            $table->string('gateway_key')->nullable();
            $table->string('token')->nullable();
            $table->string('ip_address')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('stie_id')->nullable();
            $table->timestamps();
        });

        Schema::table('payment_sessions', function (Blueprint $table) {
            $table->integer('stie_id')->after('status')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('admission_payment_sessions');
    }
}
