<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAdmissionFeeSubHeadAllocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_admission_fee_sub_head_allocations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_fee_sub_head_id');
            $table->double('amount')->nullable();
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_admission_fee_sub_head_allocations');
    }
}
