<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentFineCollectTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_fine_collect', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('student_history_id'); // Foreign key to users table, if applicable
            $table->decimal('total_fine', 8, 2)->default(0.00);
            $table->decimal('total_waiver', 8, 2)->default(0.00);
            $table->date('fine_collect_date');
            $table->integer('fine_type_id');
      
            $table->integer('year');
            $table->integer('month');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_fine_collect');
    }
}
