<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentManuallyCountAttendanceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_manually_count_attendance', function (Blueprint $table) {

            $table->bigIncrements('id');
            $table->unsignedBigInteger('student_history_id'); // Foreign key to users table, if applicable
            $table->integer('was_present')->nullable();
            $table->integer('year');
            $table->integer('month');
            $table->integer('off_day')->default(0);
            $table->integer('late_day')->default(0);
            $table->integer('academic_day')->default(0);
            $table->integer('total_present')->default(0);
       
            $table->integer('manually_attendance')->default(0);
            $table->integer('countable_absent')->default(0);
            $table->integer('countable_late')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_manually_count_attendance');
    }
}
