<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUnpaidLeaveColumnToSiteEmployeePayrollTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_employee_payroll', function (Blueprint $table) {
            $table->boolean('unpaid_leave_count')->default(0);
            $table->integer('countable_unpaid_leave')->default(0);
            $table->integer('total_unpaid_leave')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_employee_payroll', function (Blueprint $table) {
            $table->dropColumn('unpaid_leave_count');
            $table->dropColumn('countable_unpaid_leave');
            $table->dropColumn('total_unpaid_leave');
        });
    }
}
