<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCountableUnpaidLeaveToSiteEmployeeManuallyCountAttendanceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_employee_manually_count_attendance', function (Blueprint $table) {
            $table->integer('countable_unpaid_leave')->default(0);
            $table->integer('total_leave')->default(0);
            $table->integer('total_unpaid_leave')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_employee_manually_count_attendance', function (Blueprint $table) {
            $table->dropColumn('countable_unpaid_leave');
            $table->dropColumn('total_unpaid_leave');
            $table->dropColumn('total_leave');
        });
    }
}
