<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentFeeGatewaySettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_fee_gateway_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('site_payment_gateway_id');
            $table->integer('iid')->nullable();
            $table->integer('academic_fee_head_id');
            $table->integer('academic_fee_sub_head_id');
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->boolean('status')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_fee_gateway_settings');
    }
}
