<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAssessmentExpertisesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assessment_expertises', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('assessment_type_id');
            $table->string('name');
            $table->string('english_name')->nullable();
            $table->text('description')->nullable();
            $table->integer('serial')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessment_expertises');
    }
}
