<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteEmployeePayroll extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_employee_payroll', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id');
            $table->bigInteger('base_salary')->nullable();
            $table->bigInteger('total_present')->nullable();
            $table->bigInteger('total_absent')->nullable();
            $table->bigInteger('total_bonus')->nullable();
            $table->bigInteger('total_allowance')->nullable();
            $table->bigInteger('total_deduction')->nullable();
            $table->integer('year')->nullable();
            $table->integer('month')->nullable();
            $table->date('pay_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_employee_payroll');
    }
}
