<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAssessmentResultDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_assessment_result_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id')->nullable();
            $table->integer('assessment_declare_id')->nullable();
            $table->integer('assessment_id')->nullable();
            $table->integer('assessment_type_id')->nullable();
            $table->boolean('assessment_attendance_status')->default(false);
            $table->integer('fail_subject_count')->nullable();
            $table->string('total_marks')->nullable();
            $table->integer('total_subject_count')->nullable();
            $table->integer('result_subject_count')->nullable();
            $table->integer('student_rank')->nullable();
            $table->boolean('result_employee_publish_status')->default(false);
            $table->boolean('result_student_publish_status')->default(false);
            $table->boolean('result_public_publish_status')->default(false);

            $table->string('academic_days')->nullable();
            $table->string('present_days')->nullable();
            $table->string('absent_days')->nullable();
            $table->string('behaviour')->nullable();
            $table->string('cultural_activities')->nullable();
            $table->string('bncc')->nullable();
            $table->string('debate')->nullable();
            $table->string('scout')->nullable();
            $table->string('sports')->nullable();
            $table->string('others')->nullable();

            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_assessment_result_details');
    }
}
