<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAssessmentDeclareStudentSubjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_assessment_declare_student_subjects', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('site_assessment_declare_id');
            $table->integer('site_assessment_routine_id');
            $table->integer('site_assessment_declare_student_id');
            $table->integer('student_history_id');
            $table->integer('site_subject_group_condition_setting_id')->nullable();
            $table->integer('subject_topic_id')->nullable();
            $table->integer('assessment_id');
            $table->integer('assessment_type_id')->nullable();
            $table->integer('assessment_type_no_id')->nullable();
            $table->string('assessment_type_no_mark')->nullable();

            $table->boolean('assessment_attendance_status')->default(0);
            $table->boolean('assessment_held_status')->default(0);
            $table->integer('column_position')->nullable();

            $table->integer('attendance_submit_by')->nullable();
            $table->integer('attendance_submit_by_machine')->nullable();
            $table->date('attendance_update_at')->nullable();

            $table->integer('marks_input_permission')->nullable();
            $table->integer('marks_input_by')->nullable();
            $table->integer('marks_last_update_by')->nullable();

            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_assessment_declare_student_subjects');
    }
}
