<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAssessmentRoutinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_assessment_routines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('site_assessment_declare_id');
            $table->integer('site_subject_group_condition_setting_id');
            $table->integer('subject_topic_id')->nullable();
            $table->integer('assessment_id');
            $table->integer('assessment_type_id')->nullable();
            $table->integer('assessment_type_no_id')->nullable();
            $table->date('assessment_start_date')->nullable();
            $table->date('assessment_end_date')->nullable();
            $table->time('assessment_start_time')->nullable();
            $table->time('assessment_end_time')->nullable();
            $table->integer('assessment_duration')->nullable();
            $table->integer('per_day_student')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_assessment_routines');
    }
}
