<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAssessmentTypeAndTypeNoSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_assessment_type_and_type_no_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('assessment_id');
            $table->integer('assessment_type_id');
            $table->integer('assessment_type_no_id');
            $table->integer('position_show')->nullable();
            $table->string('type_access_owner')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_assessment_type_and_type_no_settings');
    }
}
