<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupSiteSubjectConditionLimitStoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_site_subject_condition_limit_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_group_id');
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_class_id');
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_subject_condition_id')->nullable();
            $table->integer('limit_amount')->nullable();
            $table->string('not_show_academic_subject_ids')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_site_subject_condition_limit_stores');
    }
}
