<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddExamAndResultColumnInSiteGroupSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {
        Schema::table('site_group_settings', function (Blueprint $table) {
           $table->string('academic_session_type_ids')->nullable();
            $table->string('academic_student_category_ids')->nullable();
            $table->string('academic_admission_type_ids')->nullable();
            $table->string('religion_ids')->nullable();
            $table->string('academic_residence_ids')->nullable();
            $table->string('emp_exam_committee_position_ids')->nullable();
            $table->string('academic_result_grade_ids')->nullable();
            $table->string('academic_result_primary_type_ids')->nullable();
            $table->string('academic_result_combine_type_ids')->nullable();
            $table->string('academic_subject_class_exam_condition_ids')->nullable();
            $table->boolean('st_in_sms')->nullable();
            $table->boolean('st_out_sms')->nullable();
            $table->boolean('present_sms_text')->nullable();
            $table->boolean('batch_present_status')->nullable();
            $table->string('examination_ids')->nullable();
            $table->string('academic_exam_type_ids')->nullable();
            $table->string('academic_result_system_ids')->nullable();
            $table->string('device_using_class_ids')->nullable();

        });

        Schema::table('site_group_academic_settings_stores', function (Blueprint $table) {
            $table->string('academic_session_type_ids')->nullable();
            $table->string('academic_student_category_ids')->nullable();
            $table->string('academic_admission_type_ids')->nullable();
            $table->string('religion_ids')->nullable();
            $table->string('academic_residence_ids')->nullable();
            $table->string('emp_exam_committee_position_ids')->nullable();
            $table->string('academic_result_grade_ids')->nullable();
            $table->string('academic_result_primary_type_ids')->nullable();
            $table->string('academic_result_combine_type_ids')->nullable();
            $table->string('academic_subject_class_exam_condition_ids')->nullable();
            $table->boolean('st_in_sms')->nullable();
            $table->boolean('st_out_sms')->nullable();
            $table->string('present_sms_text')->nullable();
        
            $table->string('present_in_sms_text')->default('[full_name][nl]In Time: [in_time] Attendance Date: [present_date] [nl]Regards:[site_name]');
            $table->string('present_out_sms_text')->default('[full_name][nl]Out Time: [out_time] Attendance Date: [present_date] [nl]Regards:[site_name]');
            $table->string('absent_sms_txt')->default('[full_name] is absent today[nl]Date:[absent_date][nl]Regards:[site_name]');
          
            $table->boolean('batch_present_status')->nullable();
            $table->string('examination_ids')->nullable();
            $table->string('academic_exam_type_ids')->nullable();
            $table->string('academic_result_system_ids')->nullable();
            $table->string('device_using_class_ids')->nullable();

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_group_settings', function (Blueprint $table) {
            //
        });
    }
}
