<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateQuizDeclareSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quiz_declare_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('quiz_declare_id')->unique();

            $table->date('start_date')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->integer('duration')->nullable();
            $table->integer('question_per_student')->nullable();
            $table->boolean('result_show_to_student_panel_status')->default(0);
            $table->boolean('sent_sms_status')->default(0);
            $table->timestamps();


        });
        Schema::table('quiz_declare_settings', function($table) {
            $table->foreign('quiz_declare_id')->references('id')->on('quiz_declares')->onDelete('cascade')->onUpdate('cascade');;

        });

       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_declare_settings');
    }
}
