<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteManuallyTestimonialSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_manually_testimonial_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->string('logo_position', 10);
            $table->boolean('border_image_status')->default(true);
            $table->string('border_image')->nullable();
            $table->boolean('watermark_status')->default(false);
            $table->string('watermark_image')->nullable();
            $table->string('initial_referance_prefix', 10)->nullable();
            $table->integer('initial_referance_number')->nullable();
            $table->string('initial_referance_suffix', 10)->nullable();
            $table->integer('site_id');
            $table->boolean('session_show_status')->default(false);
            $table->boolean('exam_center_show_status')->default(false);
            $table->string('testimonial_background_color')->default('white');
            $table->string('exam_center')->nullable();
            $table->string('exam_center_code')->nullable();
            $table->boolean('address_present_status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_manually_testimonial_settings');
    }
}
