<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAllInstitutionListsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('all_institute_lists', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('division_id')->nullable();
            $table->integer('district_id')->nullable();
            $table->integer('thana_id')->nullable();
            $table->integer('eiin')->nullable();
            $table->string('institution_name')->nullable();
            $table->integer('academic_education_level_id')->nullable();
            $table->integer('academic_institute_management_type_id')->nullable();
            $table->string('institution_mobile')->nullable();
            $table->string('institution_email')->nullable();
            $table->integer('gender_id')->nullable();
            $table->boolean('accepted_as_site')->default(false);
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::create('academic_education_levels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->string('name_key')->nullable();
            $table->timestamps();
        });

        Schema::create('academic_institute_management_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->string('name_key')->nullable();
            $table->timestamps();
        });


        Schema::create('all_institute_list_excels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('division')->nullable();
            $table->string('district')->nullable();
            $table->string('thana')->nullable();
            $table->integer('eiin')->nullable();
            $table->string('institution_name')->nullable();
            $table->string('academic_education_level')->nullable();
            $table->string('academic_institute_management_type')->nullable();
            $table->string('institution_mobile')->nullable();
            $table->string('institution_email')->nullable();
            $table->string('gender')->nullable();
            $table->timestamps();
        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('all_institution_lists');
    }
}
