<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentOnlinePaymentDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_online_payment_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('transaction_id')->nullable();
            $table->integer('payment_gateway_id')->nullable();
            $table->integer('site_student_payment_history_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->decimal('transaction_amount',9,2)->nullable();
            $table->string('transaction_status')->default('paid');
            $table->date('transaction_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_online_payment_details');
    }
}
