<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicSubjectTopicsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_subject_topics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_subject_id')->nullable();
            $table->string('head_key')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_subject_topics');
    }
}
