<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteExamQuestionInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_exam_question_infos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_subject_id')->nullable();
            $table->integer('academic_subject_topic_id')->nullable();
            $table->integer('academic_exam_type_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_exam_question_infos');
    }
}
