<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFewNewCloumnsAndChangeToSiteAccountsFixedAssets extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_accounts_fixed_assets', function (Blueprint $table) {
            $table->boolean('amortization_status')->after('depriciation_status')->nullable();
            $table->decimal('unit_price',9,2)->after('item_code')->nullable();
            $table->string('asset_type')->after('id')->nullable();
            $table->string('amortization_type')->after('depriciation_type')->nullable();
            $table->string('life_time_calculation_method')->after('life_time')->nullable();
            $table->decimal('amortization_amount',9,2)->after('depriciation_amount')->nullable();
            $table->renameColumn('depriciation_active_date', 'active_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_accounts_fixed_assets', function (Blueprint $table) {
            //
        });
    }
}
