<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClassLessonFeedbackTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_class_lesson_feedbacks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('website_class_room_id');
            $table->integer('feedback_by');
            $table->longText('feedback_detail');
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::create('site_class_lesson_reply_feedbacks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_class_lesson_feedback_id');
            $table->integer('reply_by');
            $table->longText('reply_detail');
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

        Schema::table('site_student_admission_declares', function (Blueprint $table) {

            $table->boolean('local_guardian_detail_information_add')->default(false);

        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('class_lesson_feedback');
    }
}
