<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateChequeRegistersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheque_registers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_accounts_bank_account_detail_id')->nullable();
            $table->integer('cheque_serial_no')->nullable();
            $table->string('cheque_number')->nullable();
            $table->date('cheque_issue_date')->nullable();
            $table->decimal('cheque_amount',9,2)->nullable();
            $table->string('cheque_status')->nullable();
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheque_registers');
    }
}
