<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWebsiteEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('website_events', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type')->default('event');
            $table->boolean('status')->default(0);
            $table->bigInteger('site_id')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->timestamps();
        });

        Schema::create('website_event_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('event_id');
            $table->string('event_title', 500)->nullable();
            $table->string('event_description', 1000)->nullable();
            $table->string('locale')->default('en');

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('website_events');
        Schema::dropIfExists('website_event_translations');
    }
}
