<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterNoticeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_notice_translations', function (Blueprint $table) {
            $table->string('notice_title', 1000)->after('notice_id');
            $table->dropColumn('notice_name');

        });

        Schema::table('site_notices', function (Blueprint $table) {

           // $table->string('notice_document_path')->after('doc_number')->nullable();
            $table->string('sent_request',1000)->after('doc_number')->nullable();
            $table->dateTime('web_publish_time')->after('doc_number')->nullable();
            $table->integer('web_publish_by')->after('doc_number')->nullable();
            $table->dropColumn('track_number');
            $table->dropColumn('notice_publish_date');
            $table->dropColumn('send_to_academic_department_ids');
            $table->dropColumn('send_to_academic_class_ids');
            $table->dropColumn('send_to_user_ids');
            $table->dropColumn('send_to_role_ids');
            $table->dropColumn('notice_image');
            $table->dropColumn('sent_status');
            $table->dropColumn('send_from');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_notices', function (Blueprint $table) {

        });
    }
}
