<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusFilesToStieStudnIdcardsettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_id_card_settings', function (Blueprint $table) {
            $table->boolean('status')->after('site_id');
            $table->string('card_template',500)->after('id')->default('[Logo][SiteName][StudentPicture][Name][Username][FName][MName][Shift][Class][Section][Roll][DOB][Mobile][Signature]');
            $table->integer('signature_holder')->after('id')->nullable();
            $table->dropColumn('site_name');
            $table->string('bg_path')->default('/img/site/idcard/demo.png')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_id_card_settings', function (Blueprint $table) {
            //
        });
    }
}
