<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRoomIdColumnPositionToSiteExamDeclareStudentSubjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_exam_declare_student_subjects', function (Blueprint $table) {

            $table->integer('site_base_exam_room_setting_id')->after('site_subject_examination_exam_type_mark_id')->nullable();
            $table->integer('room_id')->after('site_base_exam_room_setting_id')->nullable();
            $table->integer('column_position')->after('room_id')->nullable();
            $table->integer('seat_number')->after('column_position')->nullable();

            $table->integer('academic_seat_plan_type_id')->after('seat_number')->nullable();
            $table->integer('academic_seat_plan_style_id')->after('academic_seat_plan_type_id')->nullable();

            $table->integer('attendance_submit_by')->after('marks_last_update_by')->nullable();
        });


        Schema::table('site_base_exam_room_settings', function (Blueprint $table) {
            $table-> integer('seat_position')->after('seat_number')->nullable();
            $table-> integer('invisilator_number')->default(1)->after('seat_position');

        });


        Schema::create('academic_seat_plan_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_key');
            $table->boolean('status')->nullable();
            $table->timestamps();
        });


        Schema::create('academic_seat_plan_styles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_seat_plan_type_id');
            $table->string('name');
            $table->string('name_key');
            $table->boolean('status')->nullable();
            $table->timestamps();
        });


        Schema::table('site_rooms', function (Blueprint $table) {
            $table-> integer('invisilator_number')->default(1)->after('total_exam_seat');

        });


        Schema::create('site_exam_invigilator_selections', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id');
            $table->integer('academic_year_id');
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('examination_id');
            $table->time('exam_start_time');
            $table->date('activation_date')->nullable();
            $table->date('pause_date')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('site_id')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_exam_declare_student_subjects', function (Blueprint $table) {
            //
        });
    }
}
