<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStudentTCSTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_tc_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('application_no')->nullable();
            $table->integer('tc_no')->nullable();
            $table->string('reason', 192)->nullable();
            $table->date('generate_date')->nullable();
            $table->date('last_attendance_date')->nullable();
            $table->decimal('due_amount',9,2)->nullable();
            $table->string('result')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_tc_histories');
    }
}
