<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGlobalAcademicCalendarEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {
        Schema::create('global_academic_calendar_events', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('activate_date')->nullable();
            $table->integer('country_id')->nullable();
            $table->string('event_type')->nullable();
            $table->integer('academic_calendar_head_id')->nullable();
            $table->string('subhead_color_id')->nullable();
            $table->string('title')->nullable();
            $table->string('description', 255)->nullable();
            $table->integer('identification_number')->nullable();
            $table->string('day_name')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('global_academic_calendar_events');
    }
}
