<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDeptClassColToSiteClassSessionSerialSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_class_session_serial_settings', function (Blueprint $table) {
            $table->integer('academic_group_id')->default(0)->after('status');
            $table->integer('academic_department_id')->default(0)->after('academic_class_id');
            $table->integer('academic_shift_id')->default(0)->after('academic_class_id');
            $table->integer('academic_year_id')->default(0)->after('academic_class_id');
            $table->integer('academic_version_id')->default(0)->after('academic_class_id');
            $table->string('session_ids')->nullable()->after('academic_class_id');
            $table->string('batch_ids')->nullable()->after('academic_class_id');

            $table->boolean('session_present')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_class_session_serial_settings', function (Blueprint $table) {
            //
        });
    }
}
