<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteResultIndivisualSubjectResultStoreTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        Schema::create('site_individual_combine_subject_result_stores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id');
            $table->integer('academic_result_primary_type_id');
            $table->integer('exam_dependent_academic_subject_id');
            $table->boolean('optional_academic_subject_status')->nullable();
            $table->boolean('subject_base_pass_fail_status')->nullable();
            $table->integer('subject_count')->nullable();

            $table->text('subject_detail')->nullable();


            $table->double('subject_total_marks')->nullable();
            $table->string('subject_grade')->nullable();
            $table->double('subject_point')->nullable();

            $table->boolean('status');
            $table->integer('site_id');


            $table->timestamps();
        });



        Schema::table('site_exam_declare_students', function (Blueprint $table) {
            $table->string('academic_exam_type_ids')->nullable()->after('student_history_id');

        });


        Schema::table('site_student_primary_result_details', function (Blueprint $table) {
            $table->string('site_individual_combine_subject_result_store_ids')->nullable()->after('student_history_id');

        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_result_indivisual_subject_result_store');
    }
}
