<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentAbsentDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_absent_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('sms_followup_id')->nullable();
            $table->boolean('sms_status')->nullable();
            $table->dateTime('sms_sent_time')->nullable();
            $table->date('absent_date')->nullable();
            $table->string('reason')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('created_by')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_absent_details');
    }
}
