<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddLogCompanyInEduDevicelogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('edu_device_logs', function (Blueprint $table) {
            $table->string('log_id')->change();
            $table->string('company')->nullable()->after('device_id');
        });

        Schema::table('device_details', function (Blueprint $table) {
            $table->string('company')->nullable()->after('device_id');
        });

        Schema::table('edu_sms_follow_ups', function (Blueprint $table) {
            $table->string('res_txt_json')->nullable()->after('res_status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('edu_device_logs', function (Blueprint $table) {
            //
        });
    }
}
