<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicResultGradeAndSiteResultGradeSetting extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_result_systems', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->string('key_name')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });

        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->string('academic_result_grade_ids')->nullable();
        });

        Schema::create('site_result_system_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();


            $table->integer('academic_result_system_id');
            $table->double('number_from')->nullable();
            $table->double('number_to')->nullable();
            $table->double('point')->nullable();
            $table->double('point_from')->nullable();
            $table->double('point_to')->nullable();
            $table->integer('site_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_result_grade_and_site_result_grade_setting');
    }
}
