<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeNoticeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::rename('notice_translations', 'site_notice_translations');
        Schema::rename('notices', 'site_notices');



        Schema::table('site_notices', function (Blueprint $table) {
            $table->string('track_number')->after('notice_publish_date');
            $table->string('doc_number')->after('notice_publish_date');
        });

        Schema::table('site_notice_translations', function (Blueprint $table) {
            $table->dropColumn('site_id');
        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::rename('site_notices', 'notices');
        Schema::rename('site_notice_translations', 'notice_translations');

    }
}
