<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAcademicSubjectClassExamConditionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_subject_class_exam_conditions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->boolean('status')->default(true);
            $table->string('name_key');
            $table->timestamps();
        });


        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->string('academic_subject_class_exam_condition_ids')->nullable();
        });

        Schema::table('site_subject_group_condition_settings', function (Blueprint $table) {
            $table->integer('academic_subject_class_exam_condition_id')->nullable()->after('academic_subject_condition_ids');
            $table->integer('exam_dependent_academic_subject_id')->nullable()->after('academic_subject_class_exam_condition_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('academic_subject_class_exam_conditions');
    }
}
