<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeSomeColumnsToEvents extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('events', function (Blueprint $table) {
            $table->boolean('status')->change();
            $table->renameColumn('from_date', 'start_date')->change();
            $table->renameColumn('to_date', 'end_date')->change();
            $table->integer('academic_calendar_head_id')->nullable();
            $table->string('subhead_color_id')->nullable();
            $table->string('title', 191)->nullable();
            $table->string('description' , 255)->nullable();

            $table->date('activate_date')->nullable();
            $table->integer('identification_number')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('events', function (Blueprint $table) {
            //
        });
    }
}
