<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttErrorLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('edu_attendance_issue_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('username')->nullable();
            $table->time('access_time')->nullable();
            $table->date('attendance_date')->nullable();
            $table->string('issue_details',500)->nullable();
            $table->integer('device_id')->nullable();
            $table->integer('access_id')->nullable();
            $table->integer('site_id')->nullable();

            $table->timestamps();
        });


        Schema::dropIfExists('edu_fetched_attendance_log_details');

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_attendance_issue_details');
    }
}
