<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropSomeColumnToSiteStudentPaymentHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('site_student_payment_histories');
        Schema::create('site_student_payment_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->integer('site_student_fee_demand_slip_detail_id')->nullable();


            $table->decimal('payable_amount')->nullable();
            $table->decimal('paid_amount')->nullable();
            $table->decimal('due_amount')->nullable();
            $table->integer('payment_slip_no')->nullable();


            $table->boolean('status')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->timestamps();




        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_payment_histories', function (Blueprint $table) {
            //
        });
    }
}
