<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAttLogDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('att_log_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('company_name')->nullable();
            $table->longText('fetched_data')->nullable();
            $table->time('fetch_time')->nullable();
            $table->time('done_time')->nullable();
            $table->longText('st_saved_ids')->nullable();
            $table->longText('st_updated_ids')->nullable();
            $table->longText('emp_saved_ids')->nullable();
            $table->longText('emp_updated_ids')->nullable();
            $table->integer('fetched_by')->nullable();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('att_log_details');
    }
}
