<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeColumnToSiteStudentFeePaymentHistories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_fee_payment_histories', function (Blueprint $table) {

            $table->dropColumn('academic_version_id');
            $table->dropColumn('academic_class_id');
            $table->dropColumn('academic_class_group_id');
            $table->dropColumn('academic_department_id');
            $table->dropColumn('academic_class_deparment_year');
            $table->dropColumn('academic_class_deparment_semester_id');
            $table->dropColumn('academic_section_id');
            $table->dropColumn('academic_session_id');
            $table->dropColumn('examination_id');
            $table->dropColumn('academic_fee_head_id');
            $table->dropColumn('academic_fee_sub_head_id');
            $table->dropColumn('academic_year_id');
            $table->dropColumn('payment_type');
            $table->dropColumn('amount');
            $table->dropColumn('site_student_fee_voucher_id');
            $table->dropColumn('academic_shift_id');
            $table->dropColumn('academic_subject_id');
            $table->dropColumn('month');
            $table->dropColumn('user_id');

            $table->integer('voucher_no')->nullable();
            $table->integer('site_student_fee_demand_slip_details_id')->nullable();
            $table->integer('student_history_id')->nullable();
            $table->decimal('paid_amount',9,2)->nullable();
            $table->decimal('due_amount',9,2)->nullable();
            $table->string('created_by')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_fee_payment_histories', function (Blueprint $table) {
            //
        });
    }
}
