<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeSomeColumnToSiteStudentFeeWaiverOfferHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_fee_waiver_offer_histories', function (Blueprint $table) {

            $table->dropColumn('academic_section_id');
            $table->dropColumn('examination_id');
            $table->dropColumn('month');
            $table->dropColumn('base');
            $table->dropColumn('academic_group_id');
            $table->dropColumn('type');
            $table->dropColumn('site_student_fee_voucher_id');


            $table->boolean('status')->nullable()->change();
            $table->boolean('percantage_status')->nullable()->change();
            $table->integer('fee_head_type_id')->nullable();

        });


        Schema::create('site_fee_waiver_offer_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_fee_fine_allocation_id')->nullable();
            $table->integer('fee_head_type_id')->nullable();
            $table->integer('academic_waiver_type_id')->nullable();
            $table->integer('site_student_fee_waiver_document_id')->nullable();
            $table->integer('site_student_offer_id')->nullable();
            $table->decimal('amount')->nullable();
            $table->boolean('percantage_status')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->timestamps();

        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_fee_waiver_offer_histories', function (Blueprint $table) {
            //
        });
    }
}
