<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeTableSiteStudentFeeDemandSlipDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_fee_demand_slip_details', function (Blueprint $table) {

            $table->dropColumn('site_student_fee_demand_slip_id');
            $table->dropColumn('academic_fee_head_id');
            $table->dropColumn('academic_fee_group_id');
            $table->dropColumn('academic_fee_sub_head_id');
            $table->dropColumn('type');
            $table->renameColumn('amount','total_amount');
            $table->renameColumn('user_id','student_history_id');
            $table->string('slip_no')->nullable();
            $table->decimal('previous_due',9,2)->nullable();
            $table->string('site_student_fee_generate_ids')->nullable();
            $table->string('site_student_fee_waiver_offer_history_ids')->nullable();
            $table->integer('payment_duration')->nullable();
            $table->integer('site_group_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_fee_demand_slip_details', function (Blueprint $table) {
            //
        });
    }
}
