<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFeeHeadTypeIdToSiteStudentFeeGeneratesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_fee_generates', function (Blueprint $table) {
            $table->integer('fee_head_type_id')->nullable()->after('site_student_fee_fine_allocation_id');
        });



        Schema::create('site_fee_generates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_fee_fine_allocation_id')->nullable();
            $table->integer('fee_head_type_id')->nullable();
            $table->decimal('amount')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_fee_generates', function (Blueprint $table) {
            //
        });
    }
}
